<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\Data\Dtos\Collection\CollectionDisplayImageDTO;

trait TraitCollectionGetters
{
    use TraitCollectionProperties;

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getOwnerUserId(): string
    {
        return $this -> ownerUserId;
    }

    public function getDisplayTitle(): string
    {
        return $this -> displayTitle;
    }

    public function getDisplayImage(): CollectionDisplayImageDTO
    {
        return $this -> displayImage;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
